<?php
/**
 * @file
 * User has successfully authenticated with Twitter. Access tokens saved to session and DB.
 */

/* Load required lib files. */
session_start();
require_once('twitteroauth/twitteroauth.php');
require_once('config.php');


/* If access tokens are not available redirect to connect page. */
if (empty($_SESSION['access_token']) || empty($_SESSION['access_token']['oauth_token']) || empty($_SESSION['access_token']['oauth_token_secret'])) {
    header('Location: ./clearsessions.php');
}
/* Get user access tokens out of the session. */
$access_token = $_SESSION['access_token'];

/* Create a TwitterOauth object with consumer/user tokens. */
$connection = new TwitterOAuth(CONSUMER_KEY, CONSUMER_SECRET, $access_token['oauth_token'], $access_token['oauth_token_secret']);

/* If method is set change API call made. Test is called by default. */
$content = $connection->get('account/verify_credentials');
$screenName=$content->screen_name;



$content = $connection->get('account/rate_limit_status');
    

if($content->remaining_hits ==0){
    
echo "Current API hits remaining: {$content->remaining_hits}.";
echo "<br />";
    echo "You spent all your requests you must wait untill ".$content->reset_time;
    
}
else{


TweetsArray($screenName,$connection);


$oauth=$_POST['oauth_token'];
$oauthsec=$_POST['oauth_token_secret'];
$requested_by=$content->id;


}


function TweetsArray($username,$con){
    
$Tweets=json_decode(json_encode($con->get('statuses/user_timeline', array('screen_name' => $username,'count'=> 200))));
$Tweets=objectToArray($Tweets);


$Tweets2=array();
    $counter=0;
    
    while($Tweets[$counter]!=null){
        

        if(substr_compare($Tweets[$counter]["text"],"@",0,1)!=0){
        echo "<br />";
                echo "<br />";
        echo $Tweets[$counter]["text"];
                echo "<br />";
        echo "<br />";
        
        }
        
        
         
        $counter++;

    }
    echo "<br />";

    
}

	function objectToArray($d) {
		if (is_object($d)) {
			// Gets the properties of the given object
			// with get_object_vars function
			$d = get_object_vars($d);
		}
 
		if (is_array($d)) {
			/*
			* Return array converted to object
			* Using __FUNCTION__ (Magic constant)
			* for recursive call
			*/
			return array_map(__FUNCTION__, $d);
		}
		else {
			// Return array
			return $d;
		}
	}

  

?>  
